﻿using System;

namespace BadStaticFieldInit
{
    // Listing 3-44. Nierozważne określenie kolejności inicjalizatorów pól statycznych
    class Bar
    {
        public bool myField;
    }

    // Dyrektywy preprocesora "#if", "#else" oraz "#endif" nie zostały opisane
    // w tej książce - dodaliśmy je tutaj by Czytelnik mógł sprawdzić
    // Wystarczy zmienić "false" na "true" by został wykorzystany pierwszy 
    // przykład, którego uruchomienie spowoduje wystąpienie błędu.
#if false
    // Źle — wyjątek użycia pustej referencji
    class Foo
    {
      public static bool field2 = field1.myField;
      public static Bar field1 = new Bar();
    }
#else
    // W porządku — pola są inicjowane we właściwej kolejności
    class Foo
    {
        public static Bar field1 = new Bar();
        public static bool field2 = field1.myField;
    }
#endif

    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine(Foo.field2);

            // Jak pozbyć się ostrzeżenia kompilatora - C# nie
            // lubi definiowania pola, którego wartość nigdy nie jest 
            // modyfikowana. (Zazwyczaj nikt nie pisze tak krótkiego 
            // kodu, którego jedynym przeznaczeniem jest zmuszenie
            // kompilatora do wyświetlenia ostrzeżenia - ostrzeżenie
            // jest zazwyczaj sygnałem informującym o jakimś problemie.
            // W tym przypadku postąpiliśmy tak celowo, gdyż jest to
            // jedynie nienaturalny przykład, wymyślony w celu 
            // zilustrowania specyficznej cechy języka.
            Foo.field1.myField = true;
        }
    }
}
